import { GRID_ID_AUTOGENERATED } from "../features/rows/gridRowsUtils.js";
import { createRootSelector } from "../../utils/createSelector.js";

/**
 * Get the row id for a given row
 * @param apiRef - The grid api reference
 * @param {GridRowModel} row - The row to get the id for
 * @returns {GridRowId} The row id
 */
export const gridRowIdSelector = createRootSelector((state, row) => {
  if (GRID_ID_AUTOGENERATED in row) {
    return row[GRID_ID_AUTOGENERATED];
  }
  return state.props.getRowId ? state.props.getRowId(row) : row.id;
});